import { Platform, StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import { I18nManager } from "react-native";

export const refundDetailsStyle = StyleSheet.create({
    flex1: {
        flex: 1,
    },
    detailHeader: {
        display: "flex",
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "flex-start",
        marginTop: dpr(0),
    },
    imgCont: {
        height: dpr(75),
        width: dpr(75),
        backgroundColor: "#F3F3F3",
        borderRadius: 4,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    img: {
        height: dpr(50),
        width: dpr(50),
    },
    reason: {
        flexDirection: "row",
        flexWrap: "wrap",
        backgroundColor: "#F3F3F3",
        borderRadius: 6,
        paddingHorizontal: dpr(15),
        paddingVertical: dpr(14),
        marginTop: dpr(15),
        gap: dpr(5),
    },
    reasonTextTitle:{
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(13),
        color: "#2C2C2C",
    },
    reasonText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(13),
        color: "#2C2C2C",
    },
    uploadCont: {
        marginTop: dpr(12),
        transform: [{ scaleX: I18nManager.isRTL ? -1 : 1 }]
    },
    uploadPic: {
        width: dpr(90),
        height: dpr(90),
        borderRadius: dpr(4),
        marginRight: dpr(10),
    },
    trackRequest: {
        marginBottom: dpr(30),
    },
    trackTitle: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        color: "#2C2C2C",
        marginTop: dpr(30),
    },
    writeMessageText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginTop: dpr(20),
        marginBottom: dpr(14),
    },
    textArea: {
        borderColor: "#DFDFDF",
        borderWidth: dpr(1),
        borderRadius: dpr(4),
        paddingHorizontal: dpr(16),
        paddingVertical: dpr(12),
        textAlignVertical: "top",
        backgroundColor: "#F3F3F3",
        fontFamily: "Roboto_500Medium",
        minHeight: Platform.OS === 'ios' ? dpr(110) : 0,
        textAlign: I18nManager.isRTL ? "right" : "left",
    },
    sendMessage: {
        backgroundColor: "#FCCA19",
        borderRadius: dpr(6),
        marginTop: dpr(16),
    },
    sendMessageText: {
        color: "#2C2C2C",
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        textAlign: "center",
        paddingVertical: dpr(15),
    },
    showMessage: {
        paddingHorizontal: dpr(10),
        paddingVertical: dpr(12),
        borderColor: "#DFDFDF",
        borderWidth: dpr(1),
        borderRadius: dpr(6),
        maxHeight: dpr(300),
    },
    message: {
        display: "flex",
        flexDirection: "row",
        marginBottom: dpr(20),
    },
    userImage: {
        borderRadius: 50,
        width: dpr(40),
        height: dpr(40),
    },

    messageTextBg: {
        backgroundColor: "#F3F3F3",
        maxWidth: dpr(280),
        borderRadius: dpr(14),
    },
    messageText: {
        fontSize: dpr(12),
        color: "#868686",
        paddingHorizontal: dpr(16),
        paddingVertical: dpr(18),
    },
    messageTime: {
        fontSize: dpr(9),
        fontFamily: "Roboto_500Medium",
        color: "#868686",
        paddingTop: dpr(8),
    },
    yourMessage: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginBottom: dpr(14),
        marginTop: dpr(30),
    },
    REFERENCE: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginTop: dpr(30),
        marginBottom: dpr(9),
        textAlign: 'left',
    },
    statusText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        marginTop: dpr(30),
        textAlign: 'right',
        marginBottom: dpr(2),
    },
});

export const dynamicStatusText = (status) => {
    return status === "In progress"
        ? "#DEA512"
        : status === "Pending"
        ? "#898989"
        : status === "Accepted"
        ? "#009651"
        : status === "Delivered"
        ? "#009651"
        : status === "Declined"
        ? "#C8191C"
        : status === "Processing"
        ? "#DEA512"
        : "#898989";
};
export const dynamicStatusBG = (status) => {
    return status === "In progress"
        ? "#FEF8E7"
        : status === "Pending"
        ? "#F4F4F4"
        : status === "Accepted"
        ? "#EBF9F1"
        : status === "Delivered"
        ? "#EBF9F1"
        : status === "Declined"
        ? "#F9E8E8"
        : status === "Processing"
        ? "#FEF8E7"
        : "#F4F4F4";
};
export const dynamicStatusDot = (status) => {
    return status === "In progress"
        ? "#DEA512"
        : status === "Pending"
        ? "#898989"
        : status === "Accepted"
        ? "#009651"
        : status === "Delivered"
        ? "#009651"
        : status === "Declined"
        ? "#C8191C"
        : status === "Processing"
        ? "#DEA512"
        : status === "Opened"
        ? "#898989"
        : "#898989";
};
export const dynamicStatusForStepIndicatorText = (status) => {
    return status === "In progress"
        ? "#DEA512"
        : status === "Pending"
        ? "#898989"
        : status === "Accepted"
        ? "#009651"
        : status === "Delivered"
        ? "#009651"
        : status === "Declined"
        ? "#C8191C"
        : status === "Processing"
        ? "#DEA512"
        : status === "Opened"
        ? "#898989"
        : "#DEA512";
};
export const dynamicStatusForStepIndicatorBG = (status) => {
    return status === "In progress"
        ? "#FEF8E7"
        : status === "Pending"
        ? "#F4F4F4"
        : status === "Accepted"
        ? "#EBF9F1"
        : status === "Delivered"
        ? "#EBF9F1"
        : status === "Declined"
        ? "#F9E8E8"
        : status === "Processing"
        ? "#FEF8E7"
        : "#FEF8E7";
};
export const dynamicStatusForStepIndicatorDot = (status) => {
    return status === "In progress"
        ? "#DEA512"
        : status === "Pending"
        ? "#898989"
        : status === "Accepted"
        ? "#009651"
        : status === "Delivered"
        ? "#009651"
        : status === "Declined"
        ? "#C8191C"
        : status === "Processing"
        ? "#DEA512"
        : status === "Opened"
        ? "#898989"
        : "#DEA512";
};
